<?php
// api/routes/pan_final.php
error_reporting(0);
ini_set('display_errors', 0);
ini_set('pcre.backtrack_limit', '10000000');

if (!class_exists('\Mpdf\Mpdf')) {
    $autoloadPath = __DIR__ . '/../../libs/vendor/autoload.php';
    require_once (file_exists($autoloadPath)) ? $autoloadPath : __DIR__ . '/../../vendor/autoload.php';
}

// 1. IMAGE HANDLING
$serverRoot = '/home/directse1/print.directservices.in';
$imagePath = $serverRoot . '/assets/templates/pancard.jpg'; 
$base64Image = file_exists($imagePath) ? 'data:image/jpg;base64,' . base64_encode(file_get_contents($imagePath)) : '';

// 2. DATA MAPPING
$panNo     = strtoupper($data['pan_no'] ?? '');
$name      = strtoupper($data['name'] ?? '');
$father    = strtoupper($data['father_name'] ?? '');
$dob       = $data['dob'] ?? '';
$gender    = strtoupper($data['gender'] ?? 'MALE');

$photo     = $data['profile_image'] ?? ''; 
$signature = $data['signature_image'] ?? '';

// 3. mPDF Setup
$mpdf = new \Mpdf\Mpdf([
    'mode' => 'utf-8', 
    'format' => [210, 297], 
    'orientation' => 'P',
    'margin_left' => 0, 'margin_right' => 0, 'margin_top' => 0, 'margin_bottom' => 0,
    'default_font' => 'arial'
]);

// 4. FIXED BACKGROUND
if (!empty($base64Image)) {
    $mpdf->WriteHTML("
        <div style='position: fixed; left: 0; top: 0; width: 210mm; height: 297mm; z-index: -1000;'>
            <img src='{$base64Image}' style='width: 210mm; height: 297mm;' />
        </div>
    ");
}

// 5. CSS FOR FIELDS (Spacing & Extra Bold Added)
$css = '
    .field { position: absolute; z-index: 10; text-transform: uppercase; white-space: nowrap; }
    /* 🟢 Bold aur Letter Spacing ka logic yahan hai */
    .f-bold { 
        font-weight: 900; 
        text-shadow: 0.3pt 0.3pt 0.1pt #000; 
        letter-spacing: 0.5px; 
    }
    .sign-style { mix-blend-mode: multiply; }
';
$mpdf->WriteHTML($css, 1);

// 6. CONTENT ASSEMBLY (XY coordinates strictly same)
$html = '
    <div class="field f-bold" style="top: 194px; left: 370px; font-size: 18px; letter-spacing: 2px;">'.$panNo.'</div>
    <div class="field f-bold" style="top: 250px; left: 300px; font-size: 15px;">'.$name.'</div>
    <div class="field f-bold" style="top: 295px; left: 300px; font-size: 15px;">'.$father.'</div>
    <div class="field f-bold" style="top: 335px; left: 300px; font-size: 15px;">'.$dob.'</div>
    <div class="field f-bold" style="top: 380px; left: 300px; font-size: 15px;">'.$gender.'</div>

    '.($photo ? '<div style="position: absolute; top: 430px; left: 93px; z-index: 999;"><img src="'.$photo.'" style="width: 110px; height: 115px;" /></div>' : '').'

    '.($signature ? '<div class="sign-style" style="position: absolute; top: 472px; left: 280px; z-index: 999;"><img src="'.$signature.'" style="width: 170px; height: 38px;" /></div>' : '').'

    <div class="field f-bold" style="top: 954px; left: 193px; font-size: 10px;">'.$panNo.'</div>
    <div class="field f-bold" style="top: 1002px; left: 101px; font-size: 10px;">'.$name.'</div>
    <div class="field f-bold" style="top: 1027px; left: 101px; font-size: 10px;">'.$father.'</div>
    <div class="field f-bold" style="top: 1062px; left: 101px; font-size: 10px;">'.$dob.'</div>

    '.($photo ? '<div style="position: absolute; top: 930px; left: 95px; z-index: 999;"><img src="'.$photo.'" style="width: 60px; height: 60px;" /></div>' : '').'

    '.($signature ? '<div class="sign-style" style="position: absolute; top: 1043px; left: 178px; z-index: 999;"><img src="'.$signature.'" style="width: 140px; height: 32px;" /></div>' : '').'
';

$mpdf->WriteHTML($html, 2);
$mpdf->Output('PAN_'.$panNo.'.pdf', 'I');