<?php
// test_old_rc.php
$targetUrl = 'https://print.directservices.in/api/generate.php';

$testData = [
    'service_type' => 'RC_OLD',
    'registration_details' => ['regn_no' => 'RJ14WJ4639', 'regn_date' => '11/08/2020', 'regn_validity' => '10/08/2035'],
    'vehicle_identification' => ['chassis_no' => 'MBLHAW108L4F02496', 'engine_no' => 'HA11EXL4F02515'],
    'owner_details' => [
        'owner_name' => 'JEEWAN SAIN', 
        'relation_name' => 'LACCHU', 
        'address' => '6A MANGAL VIHAR GONER ROAD MACHH KI PIPLI LOONIYAWAS Jaipur RJ 302031'
    ],
    'fuel_emission' => ['fuel_type' => 'PETROL'],
    'vehicle_technical_details' => [
        'vehicle_class' => 'M-Cycle/Scooter',
        'maker_name' => 'HERO MOTOCORP LTD',
        'model_name' => 'HF DELUXE (I3S-SELF-DRUM-CAST)',
        'color' => 'Grey Black',
        'body_type' => 'SOLO WITH PILLION',
        'seating_capacity' => '002',
        'unladen_weight' => '000112',
        'no_of_cylinders' => '01'
    ],
    'performance_dimensions' => ['wheel_base' => '001235', 'cubic_cap' => '000097'],
    'manufacturing_finance' => ['mfg_date' => '06/2020', 'registering_authority' => 'RJ14 D 0090 JAIPUR'],
    'tax_details' => ['tax_upto' => '00/00/0000']
];

$jsonData = json_encode($testData);
?>
<form action="<?php echo $targetUrl; ?>" method="POST" target="_blank">
    <input type="hidden" name="printdata" value='<?php echo htmlspecialchars($jsonData, ENT_QUOTES); ?>'>
    <button type="submit" style="padding:20px; background:blue; color:white;">PRINT OLD RAJASTHAN RC</button>
</form>