<?php
// test_pan.php
$targetUrl = 'https://print.directservices.in/api/generate.php';

// Initial Data
$testData = [
    'service_type' => 'PAN',
    'pan_no'       => 'JWQPS8811C', // [cite: 32, 64]
    'name'         => 'VIKRAM SINGH', // [cite: 34, 58]
    'father_name'  => 'KAN SINGH', // [cite: 36, 60]
    'dob'          => '01/01/1943', // [cite: 38, 63]
    'gender'       => 'MALE',
    'profile_image'   => '', 
    'signature_image' => '' 
];
?>
<!DOCTYPE html>
<html lang="hi">
<head>
    <meta charset="UTF-8">
    <title>PAN Card Print - Upload Option</title>
    <style>
        body { font-family: Arial, sans-serif; background: #f0f2f5; padding: 50px; text-align: center; }
        .card { background: white; padding: 30px; display: inline-block; border-radius: 15px; box-shadow: 0 4px 20px rgba(0,0,0,0.1); width: 450px; }
        .input-group { margin-bottom: 20px; text-align: left; }
        label { display: block; margin-bottom: 5px; font-weight: bold; color: #333; }
        input[type="file"] { width: 100%; padding: 8px; border: 1px solid #ccc; border-radius: 5px; }
        button { background: #28a745; color: white; border: none; padding: 15px 30px; font-size: 18px; border-radius: 8px; cursor: pointer; width: 100%; transition: 0.3s; }
        button:hover { background: #218838; }
        .preview { margin-top: 10px; max-height: 100px; display: none; }
    </style>
</head>
<body>

<div class="card">
    <h2>PAN Card Print Portal</h2>
    <p>Data: <b>VIKRAM SINGH (JWQPS8811C)</b></p>
    <hr>
    
    <div class="input-group">
        <label>Upload Photo (Passport Size):</label>
        <input type="file" id="photoInput" accept="image/*">
        <img id="photoPreview" class="preview">
    </div>

    <div class="input-group">
        <label>Upload Signature:</label>
        <input type="file" id="signInput" accept="image/*">
        <img id="signPreview" class="preview">
    </div>

    <form action="<?php echo $targetUrl; ?>" method="POST" target="_blank" id="panForm">
        <input type="hidden" name="printdata" id="printdata">
        <button type="button" onclick="generatePDF()">GENERATE PAN CARD PDF</button>
    </form>
</div>

<script>
let testData = <?php echo json_encode($testData); ?>;

// Function to convert Image to Base64
function getBase64(file) {
    return new Promise((resolve, reject) => {
        const reader = new FileReader();
        reader.readAsDataURL(file);
        reader.onload = () => resolve(reader.result);
        reader.onerror = error => reject(error);
    });
}

// Preview and Store Base64
document.getElementById('photoInput').onchange = async function() {
    const file = this.files[0];
    if (file) {
        testData.profile_image = await getBase64(file);
        document.getElementById('photoPreview').src = testData.profile_image;
        document.getElementById('photoPreview').style.display = 'block';
    }
};

document.getElementById('signInput').onchange = async function() {
    const file = this.files[0];
    if (file) {
        testData.signature_image = await getBase64(file);
        document.getElementById('signPreview').src = testData.signature_image;
        document.getElementById('signPreview').style.display = 'block';
    }
};

function generatePDF() {
    // Stringify updated data
    document.getElementById('printdata').value = JSON.stringify(testData);
    document.getElementById('panForm').submit();
}
</script>

</body>
</html>