<?php
// test_rc.php
$targetUrl = 'https://print.directservices.in/api/generate.php';

// Assam RC Data (AS25Z5763) - Pure Flat Format for rc_final.php
$testData = [
    'service_type' => 'RC',
    'regNo' => 'UP25Z5763',
    'regDate' => '30-Jan-2025',
    'rcExpiryDate' => '29-Jan-2040',
    'ownerCount' => '1',
    'chassis' => 'MD2B68BX6RPH01885',
    'engine' => 'DHXPRH11772',
    'owner' => 'JAMURUDDIN ALI',
    'ownerFatherName' => 'MAJAM ALI',
    'ownership_type' => 'INDIVIDUAL',
    'presentAddress' => 'VILL-JAMLAI, PO- NAGARBERA, PS- NAGARBERA, Kamrup, Assam, 781127',
    'type' => 'PETROL',
    'fuel_descr' => 'PETROL',
    'normsType' => 'BHARAT STAGE VI',
    'vehicleClass' => 'M-CYCLE/SCOOTER',
    'class' => 'M-CYCLE/SCOOTER',
    'vehicleManufacturerName' => 'BAJAJ AUTO LTD',
    'model' => 'PULSAR 125',
    'vehicleColour' => 'EBONY BLACK SOLAS RIED',
    'bodyType' => 'WITH PILLION',
    'vehicleSeatCapacity' => '2',
    'unladenWeight' => '142',
    'grossVehicleWeight' => '292',
    'vehicleCylindersNo' => '1',
    'vehicleCubicCapacity' => '124',
    'horsepower' => '11.8',
    'wheelbase' => '1320',
    'monthYearmfg' => '11/2024',
    'rcFinancer' => 'SHRIRAM FINANCE LTD',
    'regAuthority' => 'KAMRUP(RURAL), AS',
    'state' => '',
    'state_type' => '',
    'header_details' => [
        'card_issued_date' => date('d-m-Y')
    ]
];

$jsonData = json_encode($testData);
?>

<!DOCTYPE html>
<html lang="hi">
<head>
    <meta charset="UTF-8">
    <title>Assam RC Generate Test</title>
    <style>
        body { font-family: 'Segoe UI', sans-serif; background: #f0f2f5; display: flex; justify-content: center; align-items: center; height: 100vh; margin: 0; }
        .container { background: white; padding: 40px; border-radius: 12px; box-shadow: 0 10px 25px rgba(0,0,0,0.1); text-align: center; width: 400px; }
        h2 { color: #1a73e8; }
        .info { background: #e8f0fe; padding: 15px; border-radius: 8px; margin-bottom: 25px; font-size: 14px; text-align: left; }
        button { background: #28a745; color: white; border: none; padding: 12px 25px; font-size: 16px; border-radius: 6px; cursor: pointer; width: 100%; font-weight: bold; }
    </style>
</head>
<body>

<div class="container">
    <h2>Smart Print Portal</h2>
    <div class="info">
        <strong>Vehicle No:</strong> UP25Z5763<br>
        <strong>Owner:</strong> JAMURUDDIN ALI<br>
        <strong>Mode:</strong> Flat JSON (Direct Mapping)
    </div>
    
    <form action="<?php echo $targetUrl; ?>" method="POST" target="_blank">
        <input type="hidden" name="printdata" value='<?php echo htmlspecialchars($jsonData, ENT_QUOTES, "UTF-8"); ?>'>
        <button type="submit">Print Assam RC Final PDF</button>
    </form>
</div>

</body>
</html>